/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package com.inet.application.googleanalytics.structure;

import java.net.URL;
import java.util.ArrayList;
import java.util.Set;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.inet.config.structure.model.ConfigCategory;
import com.inet.config.structure.model.ConfigConditionAction;
import com.inet.config.structure.model.ConfigGroup;
import com.inet.config.structure.model.ConfigProperty;
import com.inet.config.structure.model.ConfigPropertyGroup;
import com.inet.config.structure.model.ConfigValidationMsg;
import com.inet.config.structure.provider.AbstractStructureProvider;
import com.inet.config.structure.provider.ConfigStructureSettings;

/**
 * The ConfigStructureProvider for the google analytics plugin
 * 
 * It defines structure of the properties that will be available to be specified in Configuration Manager.
 */
public class GoogleAnalyticsStructureProvider extends AbstractStructureProvider {

    @Nonnull
    private static final String CATEGORY_GOOGLEANALYTICS    = "category.googleanalytics";

    @Nonnull
    private static final String GROUP_GOOGLEANALYTICS = "group.googleanalytics";

    /**
     * {@inheritDoc}
     */
    @Override
    public void addGroupsTo( @Nonnull Set<ConfigGroup> groups, boolean advanced, @Nonnull ConfigStructureSettings settings ) {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void addCategoriesTo( @Nonnull Set<ConfigCategory> categories, @Nonnull String groupKey, boolean advanced, @Nonnull ConfigStructureSettings settings ) {
        switch( groupKey ) {
            case CATEGORY_GROUP_COMPONENTS:
                categories.add( new ConfigCategory( 100, CATEGORY_GOOGLEANALYTICS, translate( settings, CATEGORY_GOOGLEANALYTICS ), null ) );
                break;
            default:
        }

    }

    /**
     * {@inheritDoc}
     */
    @Override
    public URL getCategoryIcon( @Nonnull String categoryKey ) {
        switch( categoryKey ) {
            case CATEGORY_GOOGLEANALYTICS:
                return getClass().getResource( "icon_48.png" );
            default:
                return null;
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void addPropertyGroupsTo( @Nonnull Set<ConfigPropertyGroup> propertyGroups, @Nonnull String categoryKey, boolean advanced, @Nonnull ConfigStructureSettings settings ) {
        switch( categoryKey ) {
            case CATEGORY_GOOGLEANALYTICS:
                propertyGroups.add( new ConfigPropertyGroup( 100, GROUP_GOOGLEANALYTICS ) );
                break;
            default:
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void addPropertiesTo( @Nonnull Set<ConfigProperty> configProperties, @Nonnull String propertyGroupKey, boolean advanced, @Nonnull ConfigStructureSettings settings ) {
        switch( propertyGroupKey ) {
            case GROUP_GOOGLEANALYTICS:
                // Default TRacking Parameters
                addTo( configProperties, GoogleAnalyticsConfigKeys.GA4_TRACKING_ID, ConfigProperty.SIMPLE_TEXT, settings );
                break;
            default:
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public void validate( @Nullable String categoryKey, @Nonnull ArrayList<ConfigValidationMsg> messages, @Nonnull ArrayList<ConfigConditionAction> conditions, @Nonnull ConfigStructureSettings settings ) {
    }

}
